package gov.va.vamf.scheduling.direct.domain

import spock.lang.Specification

class DirectBookingEligibilityCriteriaSpec extends Specification {
    private DirectBookingEligibilityCriteria directBookingEligibilityCriteria

    def setup() {
        directBookingEligibilityCriteria = new DirectBookingEligibilityCriteria()
    }

    def 'DirectBookingEligibilityCriteria should return the same settings as were set'() {
        when:
        directBookingEligibilityCriteria.coreSettings = settings

        then:
        directBookingEligibilityCriteria.coreSettings == settings

        where:
        settings << [makeCoreSettings(1), null]
    }

    def 'DirectBookingEligibilityCriteria#getSetting(String) should find a setting by id'() {
        when:
        def settings = makeCoreSettings(3)
        directBookingEligibilityCriteria.coreSettings = settings

        then:
        directBookingEligibilityCriteria.getSetting(settings[0].id).orElse(null) == settings[0]
        directBookingEligibilityCriteria.getSetting(settings[1].id).orElse(null) == settings[1]
        directBookingEligibilityCriteria.getSetting(settings[2].id).orElse(null) == settings[2]
    }

    def 'RequestEligibilityCriteria#getSetting(String) should return an empty Optional when a setting is not found'() {
        when:
        directBookingEligibilityCriteria.coreSettings = settings

        then:
        !directBookingEligibilityCriteria.getSetting('nope').isPresent()

        where:
        settings << [null, makeCoreSettings(0), makeCoreSettings(3)]
    }

    private def makeCoreSettings(count) {
        (1..count).collect { new CoreSetting("id-$it", '', '', 0) } as CoreSettings
    }
}
